/******************************************************/
/* Examples Program For "ET-BASE dsPIC30F4011"  Board */
/* Hardware    : ET-BASE dsPIC30F4011                 */
/* Target MCU  : dsPIC30F4011                         */
/*       	   : X-TAL : 7.3728 MHz                   */
/*             : Run 117.9648MHz                      */
/*             : Selec OSC Mode = XT w/PLL 16x        */
/* Compiler    : MPLAB v8.40 + C30 v3.20B      	      */
/* Last Update : 12/October/2009                      */
/******************************************************/
/* Function    : Example Use Timer1 16 Bit Mode       */
/*             : Used Timer Generate Square 1KHz      */
/******************************************************/
/* Used Timer1 Control RB0 Generate Square 1 KHz      */
/* Demo Test By Connect RB0 to Mini Speaker Beep      */
/******************************************************/

#include <p30f4011.h>                                		// dsPIC30F4011 MPU Register
#include "timer.h"											// Used Timer Library Function

/* Setup Configuration For ET-BASE dsPIC30F4011 */
_FOSC(CSW_FSCM_OFF & XT_PLL16);								// Disable Clock Switching,Enable Fail-Salf Clock
                                                            // Clock Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_OFF & PWRT_64 & MCLR_EN);					    // Disable Brown-Out ,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End Configuration For ET-BASE dsPIC30F4011 */

/* pototype  section */
void init_timer(void);										// Initial Timer Function
void delay(unsigned long int);								// Delay Time Function

/****************************/
/* Timer1 Interrupt Service */
/****************************/
void __attribute__((__interrupt__, no_auto_psv)) _T1Interrupt(void)
{
  WriteTimer1(0);											// Reset Timer1 Count
  LATBbits.LATB0 = !LATBbits.LATB0; 						// Toggle RB0 on Timer1 Match
  IFS0bits.T1IF = 0;										// Reset Timer1 Interrupt Flag
}

int main(void)
{  
  TRISBbits.TRISB0 = 0;										// Config RB0 = Output
    
  // Demo RB0 Generate 1 KHz Control Beep //
  while(1)													// Loop Continue
  {    
     init_timer();											// Initial Timer1 Genearte Square Wave 1KHz
     delay(1000000);										// Delay Beep ON

     CloseTimer1();											// Stop Timer1 
     delay(1000000);										// Delay Beep OFF
  } 
}	  

/**********************************/
/* Initial Timer for dsPIC30F4011 */
/**********************************/
void init_timer()
{		  
  CloseTimer1();											// Disable Timer1 Befor New Config

  // Config Timer1 Interrupt Control
  ConfigIntTimer1(T1_INT_ON &								// Enable Timer1 Interrupt
    		      T1_INT_PRIOR_1);							// Timer1 Interrupt Priority = 1
   
  WriteTimer1(0);											// Reset Timer1 Count
    
  //***************************************************
  // ET-BASE dsPIC30F4011 Hardware Board
  // XTAL = 7.3728MHz
  // Fosc = 7.3728 MHz x 16 = 117.9648 MHz
  // Fcy  = Fosc / 4 
  //      = 117.9648 / 4 = 29.4912 MHz
  // Tcy  = 1 / 29.4912 MHz
  //      = 33.90842 nS
  //***************************************************
  // Desire Frequency = 1 KHz (1.0 mS Period)
  // Desire Timer Prescale = 1
  // Timer Clock = 29.4912 MHz  
  // 1 Cycle = 33.90842nS
  // 1 KHz Cycle Count = 1mS / 33.90842nS
  //                   = 29491.2 Cycle
  // Desire 1 KHz Square Wave (50% Duty Cycle)
  // Define Timer1 Match = 0.5mS 
  //                     = 14745.6
  
  OpenTimer1(T1_ON &										// ON Timer1
			 T1_IDLE_STOP &									// Disable Timer1 in IDLE Mode             
			 T1_GATE_OFF &									// Disable Timer1 Gate Control
             T1_PS_1_1 &									// Timer1 Prescale = 1:1			
             T1_SYNC_EXT_OFF &								// Disable External Sync.
			 T1_SOURCE_INT ,								// Timer1 Clock Source = Internal
             14746);										// Timer1 Match Count(0.5mS Period)  		
}

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}
